/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime.mapui;

import filenet.vw.api.VWException;
import filenet.vw.api.VWRouteDefinition;
import filenet.vw.api.VWStepDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.runtime.VWTrkDataModel;
import filenet.vw.toolkit.runtime.VWTrkLaunchStep;
import filenet.vw.toolkit.runtime.VWTrkMap;
import filenet.vw.toolkit.runtime.VWTrkRoute;
import filenet.vw.toolkit.runtime.VWTrkStep;
import filenet.vw.toolkit.runtime.VWTrkStepOccurrence;
import filenet.vw.toolkit.runtime.mapui.IVWTrackerStepUI;
import filenet.vw.toolkit.runtime.mapui.VWTrackerMap;
import filenet.vw.toolkit.runtime.mapui.VWTrackerMapAttribs;
import filenet.vw.toolkit.runtime.mapui.VWTrackerMapToolbar;
import filenet.vw.toolkit.runtime.mapui.VWTrackerRouteUI;
import filenet.vw.toolkit.runtime.mapui.VWTrackerWorkflowMapPane;
import filenet.vw.toolkit.runtime.mapui.VWTrackerWorkflowScrollPane;
import filenet.vw.toolkit.runtime.mapui.resources.VWResource;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeListener;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeSource;
import filenet.vw.toolkit.utils.event.VWPropertyChangeEvent;
import filenet.vw.toolkit.utils.event.VWPropertyChangeNotifier;
import filenet.vw.toolkit.utils.mapui.VWBaseMapToolbar;
import filenet.vw.toolkit.utils.mapui.VWBaseRouteUI;
import filenet.vw.toolkit.utils.mapui.VWBaseStepUI;
import filenet.vw.toolkit.utils.mapui.VWBaseWorkflowMapPane;
import filenet.vw.toolkit.utils.mapui.VWBaseWorkflowPane;
import filenet.vw.toolkit.utils.mapui.VWMapAttribs;
import filenet.vw.toolkit.utils.mapui.VWStepRouteColors;
import filenet.vw.toolkit.utils.mapui.VWWorkflowScrollPane;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class VWTrackerWorkflowPane
extends VWBaseWorkflowPane
implements ItemListener,
IVWPropertyChangeListener,
ChangeListener {
    private Frame m_parentFrame = null;
    private VWTrkDataModel m_trackerDataModel = null;
    private Cursor m_defaultCursor = null;
    private VWStepRouteColors m_stepRouteColors = new VWStepRouteColors();
    private VWSessionInfo m_vwSessionInfo = null;
    protected Vector m_changeListeners = new Vector();

    public VWTrackerWorkflowPane(Frame parentFrame, VWTrkDataModel trackerDataModel, VWSessionInfo vwSessionInfo) {
        try {
            this.m_parentFrame = parentFrame;
            this.m_vwSessionInfo = vwSessionInfo;
            this.m_defaultCursor = this.getCursor();
            this.m_stepRouteColors.setFocusColor(Color.blue);
            this.m_stepRouteColors.setSelectionColor(Color.blue);
            Dimension dim = VWStringUtils.stringToDimension(VWResource.s_trackerWorkflowPaneDim);
            if (dim == null) {
                dim = new Dimension(725, 425);
            }
            this.setSize(dim.width, dim.height);
            this.m_trackerDataModel = trackerDataModel;
            VWPropertyChangeNotifier.addPropertyChangeListener(this);
        }
        catch (Throwable ex) {
            VWException e = new VWException(ex);
            VWDebug.logException(e);
        }
    }

    public void stateChanged(ChangeEvent e) {
        this.notifyChangeListeners();
    }

    public synchronized void addChangeListener(ChangeListener listener) {
        this.m_changeListeners.addElement(listener);
    }

    public synchronized void removeChangeListener(ChangeListener listener) {
        this.m_changeListeners.removeElement(listener);
    }

    protected void notifyChangeListeners() {
        for (int i = 0; i < this.m_changeListeners.size(); ++i) {
            ((ChangeListener)this.m_changeListeners.elementAt(i)).stateChanged(new ChangeEvent(this));
        }
    }

    public void propertyChange(VWPropertyChangeEvent event) {
        block14: {
            try {
                Object obj = event.getSource();
                if (!(obj instanceof IVWPropertyChangeSource)) break block14;
                IVWPropertyChangeSource source = (IVWPropertyChangeSource)obj;
                int type = event.getID();
                Vector items = null;
                switch (type) {
                    case 701: 
                    case 702: 
                    case 704: {
                        items = source.getItemsChanged();
                        if (items == null) {
                            return;
                        }
                        boolean stepId = false;
                        for (int i = 0; i < items.size(); ++i) {
                            IVWTrackerStepUI step = null;
                            obj = items.elementAt(i);
                            if (obj == null) continue;
                            if (obj instanceof VWTrkStep) {
                                step = this.findStep((VWTrkStep)obj);
                            } else if (obj instanceof VWTrkStepOccurrence) {
                                step = this.findStep(((VWTrkStepOccurrence)obj).getStep());
                            }
                            if (step == null) continue;
                            if (type == 701) {
                                step.updateLockStatusIcon();
                            } else {
                                step.updateStepOccurrence();
                            }
                            if (!(step instanceof VWBaseStepUI)) continue;
                            this.invalidStepRegion((VWBaseStepUI)((Object)step));
                        }
                        break;
                    }
                    case 705: {
                        Vector stepCollection = this.m_trackerDataModel.getStepCollection();
                        if (stepCollection == null || stepCollection.size() <= 0) break;
                        VWTrkStep step = null;
                        IVWTrackerStepUI stepUI = null;
                        for (int i = 0; i < stepCollection.size(); ++i) {
                            step = (VWTrkStep)stepCollection.elementAt(i);
                            if (step == null || step.getLastOccurrence() == null || (stepUI = this.findStep(step)) == null) continue;
                            step.setSelectedOccurrenceIndex(-1);
                            stepUI.updateStepOccurrence();
                            if (!(stepUI instanceof VWBaseStepUI)) continue;
                            this.invalidStepRegion((VWBaseStepUI)((Object)stepUI));
                        }
                        break;
                    }
                }
            }
            catch (Throwable ex) {
                VWException e = new VWException(ex);
                VWDebug.logException(e);
            }
        }
    }

    public void itemStateChanged(ItemEvent e) {
        try {
            Object source = e.getSource();
            if (source == this) {
                return;
            }
            if (source instanceof VWTrackerWorkflowMapPane) {
                ItemEvent event = new ItemEvent(this, e.getID(), e.getItem(), e.getStateChange());
                this.notifySelectListeners(event);
            } else {
                if (this.m_activeMapPane != null) {
                    this.m_activeMapPane.itemStateChanged(e);
                }
                this.scrollSelectionToVisible();
            }
        }
        catch (Throwable ex) {
            VWException vwex = new VWException(ex);
            VWDebug.logException(vwex);
        }
    }

    public void setStepStatusVisible(boolean bShow) {
        if (this.m_mapAttribs != null && this.m_mapAttribs instanceof VWTrackerMapAttribs) {
            ((VWTrackerMapAttribs)this.m_mapAttribs).setStepStatusVisible(bShow);
        }
    }

    protected VWTrackerRouteUI findRoute(int routeId) {
        if (this.m_activeMapPane != null) {
            return ((VWTrackerWorkflowMapPane)this.m_activeMapPane).findRoute(routeId);
        }
        return null;
    }

    protected VWTrackerRouteUI findRoute(VWTrkRoute route) {
        if (this.m_activeMapPane != null) {
            return ((VWTrackerWorkflowMapPane)this.m_activeMapPane).findRoute(route);
        }
        return null;
    }

    public VWBaseRouteUI findRoute(VWRouteDefinition routeDefinition) {
        return super.findRoute(routeDefinition);
    }

    protected IVWTrackerStepUI findStep(int stepId) {
        if (this.m_activeMapPane != null) {
            return ((VWTrackerWorkflowMapPane)this.m_activeMapPane).findStep(stepId);
        }
        return null;
    }

    protected IVWTrackerStepUI findStep(int mapId, int stepId) {
        if (this.m_activeMapPane != null) {
            return ((VWTrackerWorkflowMapPane)this.m_activeMapPane).findStep(stepId);
        }
        return null;
    }

    public VWBaseStepUI findStep(VWStepDefinition stepDefinition) {
        return super.findStep(stepDefinition);
    }

    protected IVWTrackerStepUI findStep(VWTrkStep step) {
        int mapId = step.getMapId();
        VWTrkMap map = this.m_trackerDataModel.getMap(mapId);
        String mapName = map.getMapName();
        VWTrackerWorkflowMapPane mapPane = this.getMapPane(mapName);
        if (mapPane != null) {
            return mapPane.findStep(step);
        }
        return null;
    }

    protected VWTrackerWorkflowMapPane getMapPane(String mapName) {
        return (VWTrackerWorkflowMapPane)this.m_mapCache.getMapPane(mapName);
    }

    Frame getParentFrame() {
        return this.m_parentFrame;
    }

    public VWSessionInfo getSessionInfo() {
        return this.m_vwSessionInfo;
    }

    protected VWStepRouteColors getStepRouteColors() {
        return this.m_stepRouteColors;
    }

    public void initialize() {
        this.setWorkflowDefinition();
    }

    protected void initMapToolbar() {
        if (this.m_mapToolbar != null) {
            this.m_mapToolbar.init();
        }
    }

    protected boolean isSameSelection(Object[] objects) {
        block13: {
            try {
                Object[] curSelection;
                int objCount = 0;
                int curCount = 0;
                if (objects != null) {
                    objCount = objects.length;
                }
                if ((curSelection = this.getSelectedObjects()) != null) {
                    curCount = curSelection.length;
                }
                if (objCount == curCount) {
                    int stepId = -1;
                    int routeId = -1;
                    if (objCount != 0) {
                        for (int i = 0; i < objCount; ++i) {
                            boolean bFound = false;
                            if (objects[i] instanceof VWStepDefinition) {
                                stepId = ((VWStepDefinition)objects[i]).getStepId();
                                routeId = -1;
                            } else if (objects[i] instanceof VWRouteDefinition) {
                                routeId = ((VWRouteDefinition)objects[i]).getRouteId();
                                stepId = -1;
                            } else {
                                return false;
                            }
                            for (int j = 1; j < curCount; ++j) {
                                Object obj = curSelection[j];
                                if (obj instanceof VWStepDefinition && stepId == ((VWStepDefinition)obj).getStepId()) {
                                    bFound = true;
                                    break;
                                }
                                if (!(obj instanceof VWRouteDefinition) || routeId != ((VWRouteDefinition)obj).getRouteId()) continue;
                                bFound = true;
                                break;
                            }
                            if (bFound) continue;
                            return false;
                        }
                    }
                    break block13;
                }
                return false;
            }
            catch (Throwable ex) {
                VWException e = new VWException(ex);
                VWDebug.logException(e);
                return false;
            }
        }
        return true;
    }

    protected VWBaseWorkflowMapPane newMapPane() {
        VWTrackerWorkflowMapPane mapPane = new VWTrackerWorkflowMapPane(this);
        return mapPane;
    }

    protected VWBaseMapToolbar newMapToolbar() {
        if (this.m_mapToolbar == null) {
            this.m_mapToolbar = new VWTrackerMapToolbar(this);
        }
        return this.m_mapToolbar;
    }

    public VWTrackerMapToolbar getTrackerMapToolbar() {
        return (VWTrackerMapToolbar)this.m_mapToolbar;
    }

    protected VWWorkflowScrollPane newScrollPane() {
        if (this.m_scrollPane == null) {
            this.m_scrollPane = new VWTrackerWorkflowScrollPane();
        }
        return this.m_scrollPane;
    }

    protected VWMapAttribs newMapAttributes() {
        if (this.m_mapAttribs == null) {
            this.m_mapAttribs = new VWTrackerMapAttribs(this);
        }
        return this.m_mapAttribs;
    }

    protected void scrollSelectionToVisible() {
        try {
            Object[] selection = this.getSelectedObjects();
            if (selection != null) {
                VWBaseWorkflowMapPane activeMapPane = this.getActiveMapPane();
                Rectangle rect = null;
                for (int i = 0; i < selection.length; ++i) {
                    JComponent route;
                    Object obj = selection[i];
                    Rectangle r = null;
                    if (obj instanceof VWRouteDefinition) {
                        route = this.findRoute((VWRouteDefinition)obj);
                        if (route != null) {
                            r = ((VWBaseRouteUI)route).getBounds();
                        }
                    } else if (obj instanceof VWStepDefinition) {
                        route = this.findStep((VWStepDefinition)obj);
                        if (route != null) {
                            r = ((VWBaseStepUI)route).getBounds();
                        }
                    } else {
                        r = null;
                    }
                    if (rect == null) {
                        rect = r;
                        continue;
                    }
                    rect.add(r);
                }
                if (rect != null) {
                    activeMapPane.scrollRectToVisible(rect);
                }
            }
        }
        catch (Throwable ex) {
            VWException e = new VWException(ex);
            VWDebug.logException(e);
        }
    }

    public void selectLaunchStep() {
        VWTrkLaunchStep launchStep = this.m_trackerDataModel.getLaunchStep();
        if (launchStep != null) {
            int mapId = launchStep.getMapId();
            int[] stepId = new int[]{launchStep.getStepId()};
            this.selectSteps(mapId, stepId);
        }
    }

    public void selectSteps(int mapId, int[] stepIds) {
        this.setActiveMapPane(mapId);
        this.selectSteps(stepIds);
    }

    public void selectSteps(int[] stepIds) {
        if (this.m_activeMapPane != null) {
            ((VWTrackerWorkflowMapPane)this.m_activeMapPane).selectSteps(stepIds);
        }
    }

    protected void setActiveMapPane(int mapId) {
        if (this.m_activeMapPane != null && ((VWTrackerWorkflowMapPane)this.m_activeMapPane).getMapId() == mapId) {
            return;
        }
        VWTrkMap map = this.m_trackerDataModel.getMap(mapId);
        String mapName = map.getMapName();
        this.setActiveMapPane(this.findMap(mapName).getMapPane());
    }

    protected void setActiveMapPane(VWBaseWorkflowMapPane mapPane) {
        if (mapPane != null && mapPane instanceof VWTrackerWorkflowMapPane && this.m_trackerDataModel != null) {
            VWTrackerWorkflowMapPane trackerMapPane = (VWTrackerWorkflowMapPane)mapPane;
            VWTrkMap mapData = trackerMapPane.getMapData();
            this.m_trackerDataModel.setSelectedMap(mapData);
        }
        super.setActiveMapPane(mapPane);
    }

    public void setWorkflowDefinition() {
        String initialMapName = null;
        this.m_workflowDefinition = this.m_trackerDataModel.getWorkflowDefinition();
        this.m_scrollPane.getViewport().removeAll();
        this.m_activeMapPane = null;
        try {
            Vector maps = this.m_trackerDataModel.getMaps();
            int initialMapId = this.m_trackerDataModel.getInitialMapId();
            VWTrkMap initialMap = null;
            if (this.m_workflowDefinition == null || maps == null || maps.size() == 0) {
                VWDebug.logWarning(VWResource.s_nullWorkflowDefinition);
            } else {
                VWTrkMap map;
                Object obj;
                int mainMapId = this.m_trackerDataModel.getWorkflowDefinition().getMainMap().getMapId();
                if (initialMapId == -1) {
                    initialMapId = mainMapId;
                }
                boolean found = false;
                for (int i = 0; i < maps.size(); ++i) {
                    obj = maps.elementAt(i);
                    if (obj == null || !(obj instanceof VWTrkMap) || (map = (VWTrkMap)obj).getMapId() != initialMapId) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    initialMapId = mainMapId;
                }
                String mainMapName = this.m_trackerDataModel.getWorkflowDefinition().getMainMap().getName();
                for (int i = 0; i < maps.size(); ++i) {
                    boolean bMainMap = false;
                    obj = maps.elementAt(i);
                    if (obj == null || !(obj instanceof VWTrkMap)) continue;
                    map = (VWTrkMap)obj;
                    String mapName = map.getMapDefinition().getName();
                    if (mainMapName != null && mapName != null && mapName.compareToIgnoreCase(mainMapName) == 0) {
                        bMainMap = true;
                    }
                    VWTrackerMap mapWrapper = new VWTrackerMap((VWBaseWorkflowPane)this, (VWTrkMap)obj);
                    this.m_mapCache.addCurrentMap(mapWrapper);
                    if (bMainMap) {
                        mapWrapper.getMapPane();
                    }
                    if (map.getMapId() != initialMapId) continue;
                    mapWrapper.getMapPane();
                    initialMapName = map.getMapName();
                    initialMap = map;
                }
            }
            ((VWTrackerMapToolbar)this.m_mapToolbar).setRendererOnMapComboBox();
            this.m_mapToolbar.initMapCombo(this.m_mapCache.toVector());
            this.selectMapFromMapCombo(initialMapName);
        }
        catch (Throwable ex) {
            VWException e = new VWException(ex);
            VWDebug.logException(e);
        }
    }

    public void removeReferences() {
        this.m_parentFrame = null;
        this.m_trackerDataModel = null;
        this.m_defaultCursor = null;
        this.m_stepRouteColors = null;
        if (this.m_changeListeners != null) {
            this.m_changeListeners.removeAllElements();
            this.m_changeListeners = null;
        }
        VWPropertyChangeNotifier.removePropertyChangeListener(this);
        this.removeAll();
        super.removeReferences();
    }
}

